'use strict';

/* Validate Form */
function initializeValidate() {
    $('[data-validation]').each(function () {
        var validator = $(this),
            inputs = validator.find('input:not(:checkbox), textarea'),
            submit = validator.find('button[type=submit]'),
            stopSubmit = false;

        validator.on('change keyup', 'input[data-name]', function () {
            var elm = $(this);
            checkValidity(elm);
        });

        submit.on('click', function (e) {
            var mass = [];

            stopSubmit = false;

            for (var i = 0; i < inputs.length; i++) {

                var input = inputs[i];
                // console.log('Инпут ' + input);
                mass.push(input);

                if (input.checkValidity() == true) {
                    var elm = input;
                    // console.log(elm);
                    checkValidity(elm);
                    //stopSubmit = false;
                }
                else {
                    // console.log('not');
                }

                // NB! ТАК НЕ ДОЛЖНО БЫТЬ!!!! Если последнее поле валидно — отправится вся форма!
                // if ($(input).parent().hasClass('valid')) {
                //     stopSubmit = false;
                // } else {
                //     stopSubmit = true;
                // }

                if ($(input).parent().hasClass('invalid')) {
                        stopSubmit = true;
                }

            }

            if (stopSubmit) {
                e.preventDefault();
            }
        });
    });
}

function checkValidity(elm) {
    var elm = $(elm),
        val = elm.val(),
        block = elm.parent(),
        name_reg = /^[A-Za-zА-Яа-яЁё\-\s]+$/,
        text_reg = /^[-A-Za-zА-Яа-яёЁ«»'"\s\d]/,
        mail_reg = /^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}])|(([a-zA-Z-А-Яа-яЁё\-0-9]+\.)+[a-zA-Z]{2,}))$/,
        phone_reg = /^(\s*)?(\+)?([- _():=+]?\d[- _():=+]?){11,12}(\s*)?$/,
        phone_tagline = /^(\+)?[-0-9\(\)]{6,20}$/,
        message = elm.data('message') ? elm.data('message') : 'Ошибка ввода';

    if (elm.prop('disabled')) {
        return;
    } else if (elm.is('[data-name="name"]')) {
        // console.log('"Элемент ==');
        // console.log(elm.attr('data-name'));
        if (name_reg.test(val)) {
            block.removeClass('invalid').addClass('valid');
            block.find('.form__error').remove();
        } else {
            block.removeClass('valid').addClass('invalid');
            if (block.find('.form__error').length) {
                return false;
            } else {
                block.append('<span class="form__error">' + message + '</span>');
            }
        }
    } else if (elm.is('[data-name="text"]')) {
        if (text_reg.test(val)) {
            block.removeClass('invalid').addClass('valid');
            block.find('.form__error').remove();
        } else {
            block.removeClass('valid').addClass('invalid');
            if (block.find('.form__error').length) {
                return false;
            } else {
                block.append('<span class="form__error">' + message + '</span>');
            }
        }
    } else if (elm.is('[data-name="email"]')) {
        if (mail_reg.test(val)) {
            block.removeClass('invalid').addClass('valid');
            block.find('.form__error').remove();
        } else {
            block.removeClass('valid').addClass('invalid');
            if (block.find('.form__error').length) {
                return false;
            } else {
                block.append('<span class="form__error">' + message + '</span>');
            }
        }
    } else if (elm.is('[data-name="phone"]')) {
        if (phone_tagline.test(val)) {
            block.removeClass('invalid').addClass('valid');
            block.find('.form__error').remove();
        } else {
            block.removeClass('valid').addClass('invalid');
            if (block.find('.form__error').length) {
                return false;
            } else {
                block.append('<span class="form__error">' + message + '</span>');
            }
        }
    }

    else if (elm.is('[data-name="company"]')) {
        if (text_reg.test(val)) {
            block.removeClass('invalid').addClass('valid');
            block.find('.form__error').remove();
        } else {
            block.removeClass('valid').addClass('invalid');
            if (block.find('.form__error').length) {
                return false;
            } else {
                block.append('<span class="form__error">' + message + '</span>');
            }
        }
    }
}

function accordionInit() {
    $('[data-accordion]').each(function (i) {

        var accordion = $(this).eq(i);
        var tumbler = accordion.find('.program-list__headline');
        var review = accordion.find('.program-list__review');
        var trigger = accordion.find('.program-list__trigger');

        trigger.on('click', function(e) {
            $('.js-program-list__text').html(($('.js-program-list__text').html() == 'Раскрыть') ? 'Свернуть' : 'Раскрыть');
            e.preventDefault();
            tumbler.siblings(review).slideToggle(350);
            return false;
        });

        tumbler.on('click', function (e) {
            e.preventDefault();
            $(this).siblings(review).slideToggle(350);
            return false;
        });
    });
}

function modalInit() {
    $('[data-modal-trigger]').each(function () {

        var trigger = $(this);
        var modal = $('[data-modal]');
        var close = modal.find('[data-modal="close"]');

        trigger.on('click', function (e) {
            e.preventDefault();
            var modalId = $(this).data('modal-trigger');
            //console.log(modalId);

            $('html').addClass('modal-is-open');
            $(modalId).removeClass('modal-hidden').addClass('modal-open');
        });

        close.on('click', function (e) {
            e.preventDefault();

            $(this).parents('[data-modal]').removeClass('modal-open').addClass('modal-hidden');
            $('html').removeClass('modal-is-open');
        });

        $('.modal-stage').on('click', function (e) {
            if (!$('.modal-container').is(e.target) && $('.modal-container').has(e.target).length === 0) {
                $('[data-modal]').removeClass('modal-open').addClass('modal-hidden');
                $('html').removeClass('modal-is-open');
            }
        });

        /*if(window.location.hash && (trigger = $(window.location.hash)) && trigger.length) {
            var modalId = $(window.location.hash);
            //console.log(modalId);

            $('html').addClass('modal-is-open');
            $(modalId).removeClass('modal-hidden').addClass('modal-open');
        }*/


        $(document).keyup(function(e) {
            if (e.keyCode === 27) {
                $('[data-modal]').removeClass('modal-open').addClass('modal-hidden');
                $('html').removeClass('modal-is-open');
            }
        });
    });
}

function landingHeaderScroll(){
    var scrolled = $(window).scrollTop();
    var header = $('.header');

    if(scrolled >= 1){
        header.addClass('is-sticky');
    }
    else {
        header.removeClass('is-sticky');
    }
}

function hash() {
	var hash = location.hash.replace(/^#/, '');
	//console.log($('[data-modal='+ hash +']'));

	if(location.hash && $('[data-modal='+ hash +']').length) {
		var modalId = $('#'+hash);
		//console.log(modalId);

		$('html').addClass('modal-is-open');
		modalId.removeClass('modal-hidden').addClass('modal-open');
	} else {
		if(location.hash.length != 0) {
			var modalId = $('#'+hash);
			//console.log(modalId);

			$('html').removeClass('modal-is-open');
			$('[data-modal]').addClass('modal-hidden').removeClass('modal-open');

			modalId.stop().animate({
				scrollTop: modalId.offset().top
			}, 800);
		}
	}
}

$(document).ready(function () {
	hash();
    var metrika_id = "";

	$(window).on('popstate', function () {
		hash();
	});

    if (metrika_id == 'Tagline') {
        $('.js-button').on('click', function(){
            var jq_this = $(this);
            var ym_action = jq_this.attr('data-apply-form-id');
            switch(ym_action) {
                case 'menu_callback':
                    yaCounter26987553.reachGoal('creativepeople-cgi__menu-callback--open');
                    break;
                case 'first_page_apply':
                    yaCounter26987553.reachGoal('creativepeople-cgi__first-page-apply--open');
                    break;
                case '3_directions':
                    yaCounter26987553.reachGoal('creativepeople-cgi__3-directions-apply--open');
                    break;
                case 'how_is_training_apply':
                    yaCounter26987553.reachGoal('creativepeople-cgi__how-is-training-apply--open');
                    break;
                case 'homework_2_levels':
                    yaCounter26987553.reachGoal('creativepeople-cgi__homework-2-levels--open');
                    break;
                case 'faq':
                    yaCounter26987553.reachGoal('creativepeople-cgi__faq--open');
                    break;
                case 'what_else_apply':
                    yaCounter26987553.reachGoal('creativepeople-cgi__what-else-apply--open');
                    break;
                case 'common_technologies_apply':
                    yaCounter26987553.reachGoal('creativepeople-cgi__common-technologies-apply--open');
                    break;
                case 'course_cost_apply':
                    yaCounter26987553.reachGoal('creativepeople-cgi__course-cost-apply--open');
                    break;
            }
        })
    }

    if ($('[data-validation]').length) {
        initializeValidate();
    }

    if ($('[data-accordion]').length) {
        accordionInit();
    }

    if ($('[data-modal]').length) {
        modalInit();
    }


    $(window).on('scroll', function(){
        landingHeaderScroll();
    });

    landingHeaderScroll();


    $('form').each(function() {

        var form = $(this);
        var checkbox = form.find('input[type=checkbox]');
        var btn = form.find('button[type=submit]');

        if(checkbox.is(':checked')) {
            btn.prop('disabled', false);
        } else {
            btn.prop('disabled', true);
        }


        checkbox.change(function() {
            if(checkbox.is(':checked')) {
                btn.prop('disabled', false);
            } else {
                btn.prop('disabled', true);
            }
        });



        // popup form
        form.on('submit', function (e) {
            e.preventDefault();

            var $this = $(this);
            var checkbox = $this.find('input[type=checkbox]');
            var btn = $(this).find('button[type=submit]');

            var data = $(this).serialize();
            var msg = 'Спасибо, ваши данные успешно отправлены';
            var jq_form = $(this);

            //TODO убрать когда запустим очереди
            btn.attr('disabled', 'disabled');
            setTimeout(function () {
                btn.attr('disabled', '');
            }, 3000);

            if(checkbox.is(':checked')) {
                btn.attr('disabled', '');

                $.ajax({
                    type: 'POST',
                    url: ajax_url,
                    dataType: ajax_dataType,
                    data: data,
                    success: function success(data, statusText, xhr) {
                        if (xhr.status === 200) {
                            btn.prop('disabled', true);
                            // fbq('track', 'Lead'); // отправка для fb
                            // yaCounter45687648.reachGoal(data.type);
                            // это стилизованный текст об успешной отправке
                            if (metrika_id == 'Tagline') {
                                var form_id = jq_form.find('input[name="form_id"]').val();
                                switch (form_id) {
                                    case 'menu_callback':
                                        // yaCounter26987553.reachGoal('creativepeople-cgi__menu-callback--send');
                                        break;
                                    case 'first_page_apply':
                                        yaCounter26987553.reachGoal('creativepeople-cgi__first-page-apply--send');
                                        break;
                                    case '3_directions':
                                        yaCounter26987553.reachGoal('creativepeople-cgi__3-directions-apply--send');
                                        break;
                                    case 'how_is_training_apply':
                                        yaCounter26987553.reachGoal('creativepeople-cgi__how-is-training-apply--send');
                                        break;
                                    case 'homework_2_levels':
                                        yaCounter26987553.reachGoal('creativepeople-cgi__homework-2-levels--send');
                                        break;
                                    case 'faq':
                                        yaCounter26987553.reachGoal('creativepeople-cgi__faq--send');
                                        break;
                                    case 'what_else_apply':
                                        yaCounter26987553.reachGoal('creativepeople-cgi__what-else-apply--send');
                                        break;
                                    case 'common_technologies_apply':
                                        yaCounter26987553.reachGoal('creativepeople-cgi__common-technologies-apply--send');
                                        break;
                                    case 'course_cost_apply':
                                        yaCounter26987553.reachGoal('creativepeople-cgi__course-cost-apply--send');
                                        break;
                                    case 'footer_consult':
                                        yaCounter26987553.reachGoal('creativepeople-cgi__footer-consult--send');
                                        gtag('event', 'treatment', { 'event_category': 'request', 'event_action': 'zakaz_creativepeople-tech-design-cgi-advice' });
                                        break;
                                }
                                if (form_id != 'footer_consult') {
                                    gtag('event', 'treatment', { 'event_category': 'request', 'event_action': 'zakaz_creativepeople-tech-design-cgi-order' });
                                }
                                document.location = '/creativepeople-tech-design-cgi/tell-us-more';
                            }
                            // form.html('' + '<div class="form-success">' + '<div class="form-success__text">'+ msg +'</div>' + '</div>' + '');
                        }
                    },
                    error: function error(xhr, str) {
                        console.log('Возникла ошибка: ' + xhr.status);
                    }
                });

            } else {
                btn.attr('disabled', 'disabled');
                return false;
            }

            return false;
        });

    });


    // $(document).on('click', '.footer__button a', function() {
    //     yaCounter45687648.reachGoal('OUTLOOK');
    // });


    if($('#ask').length) {
        var top = $('#ask').offset().top;
        //console.log(top);

        $('a.goTo').on('click', function (e) {
            e.preventDefault();

            $('.page').animate({ scrollTop: top }, 1500);
        });
    }


    $('.leader').each(function() {
        var container = $(this);
        var nav = container.find('.leader-nav');
        var navItem = nav.find('.leader-nav__item');

        navItem.on('click', function(e) {
            e.preventDefault();
            var href = $(this).attr('href');

            $(this).addClass('current').siblings().removeClass('current');
            $(href).addClass('current').siblings().removeClass('current');
        });
    });


    $('.course-tab, .level-nav').each(function() {
        var tab = $(this);
        var tabItem = tab.find('.course-tab__item, .level-nav__item');

        tabItem.on('click', function(e) {
            e.preventDefault();
            var id = $(this).attr('href');

            $(this).addClass('current').siblings().removeClass('current');
            $(id).addClass('current').siblings().removeClass('current');
        });
    });


    $('.faq').each(function() {
       var faq = $(this);
       var faqItem = faq.find('.faq__item');
       var faqTitle = faq.find('.faq__title');

       faqTitle.on('click', function(e) {
           e.preventDefault();

           $(this).parent().toggleClass('current');
           $(this).parent().find('.faq__content').slideToggle(300).toggleClass('current');
       });
    });

    if ($('.js-slider').length) {
        var slider = $('.js-slider');
        slider.slick({
            infinite: false,
            slidesToShow: 1,
            slidesToScroll: 1,
            fade: true,
            cssEase: 'linear'
        });
        slider.css({'padding-left': 0, 'padding-right': 0});
        slider.append('<span class="paginator">');
        var paginator = $('.paginator');
        paginator.append('<span class="current">');
        paginator.append('<span class="count-of-slides">');
        $('.count-of-slides').html( '/' + slider.slick("getSlick").slideCount);
        $('.slider .current').html('1');
        slider.on('afterChange', function(event, slick, currentSlide, nextSlide){
            $('.slider .current').html(currentSlide + 1);
        });

    }


    $(function(){
        $(document)
            .on('click', '.js-landingBurgerMenu', function(){
                $('.js-landingMenu').toggleClass('is-open');
            })
            .on('click', '.js-landingMenuClose', function(){
                $('.js-landingMenu').removeClass('is-open');
            })
            .on('click', '.js-scrollNav a', function(){
                if($(window).width() <= 767){
                    $('.js-landingMenu').removeClass('is-open');
                }
            });

        $('.js-scrollNav').onePageNav({
            currentClass: 'is-active',
            changeHash: false,
            offsetNum: $(window).width() <= 767 ? 0 : 0,
            scrollSpeed: 750,
            scrollThreshold: 0.5,
            filter: ':not(.external)',
            easing: 'swing',
            begin: function() {

            },
            end: function() {
                $('.js-landingMenu').removeClass('is-open');
            },
            scrollChange: function($currentListItem) {

            }
        });

        $(document).on('click', function(e) {
            if(!$('.landing-menu').is(e.target) && $('.landing-menu').has(e.target).length === 0
                && !$('.js-landingBurgerMenu').is(e.target) && $('.js-landingBurgerMenu').has(e.target).length === 0
            ) {
                $('.js-landingMenu').removeClass('is-open');
            }
        });
    });


    $(function() {
        var carousel = $('.js-carousel');
        var carouselImage = carousel.find('.cases__image');
        var carouselWidth = carouselImage.outerWidth();
        var carouselHeight = carouselImage.outerHeight();

        carouselImage.css('width', carouselWidth);

        var fullWidth = 0;
        carouselImage.each(function(){
            fullWidth += $(this).width()
        });
        //console.log(fullWidth);

        carousel.children().wrapAll('<div class="cases-outside" />');

        $('.cases-outside').css({
            width: fullWidth,
            height: carouselHeight
        });

        setInterval(function() {

            $('.cases-outside').animate({
                left: -carouselWidth
            }, 25000, function () {
                $('.cases-outside').css('left', 0);
            });

        });
    });
});
